<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NMadmin extends Model 
{

    protected $table = 'nm_admins';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'matricule', 'email', 'passWord', 'name', 'statut', 'telephone');
    protected $visible = array('slug', 'matricule', 'email', 'passWord', 'name', 'statut', 'telephone');

    public function entreprise()
    {
        return $this->hasMany('App\Models\Entreprise', 'id_NMadmin');
    }

    public function versement()
    {
        return $this->hasMany('App\Models\Versement', 'id_nm_admin');
    }

}